# snARASM Chrome Extension

Chrome extension component of the snARASM (SIMS NET Alice's Restaurant Anti-Spam Massacre) spam reporting system.

## Overview

This Chrome extension integrates with Gmail to provide one-click spam reporting functionality. When users select spam messages in Gmail and click the "Report" button, the extension:

1. Extracts sender information from selected messages
2. Communicates with the Java backend via Chrome native messaging
3. Triggers comprehensive spam analysis and abuse report generation
4. Automatically deletes the reported spam messages
5. Refreshes the Gmail view

## Architecture

```
Chrome Extension (JavaScript)
    ↓ Native Messaging Protocol
Java Backend (snARASM-standalone.jar)
    ↓ Analysis & WHOIS Lookups
Gmail API (for message operations)
    ↓ SMTP
Abuse Report Emails → ISPs, Registrars, Web Hosts
```

## Components

### content.js
- Injects UI into Gmail pages
- Creates the "Report" button with dynamic text based on selection
- Detects message selection in both list and detail views
- Handles user interactions and message extraction
- Communicates with background script

Key features:
- Fixed-position button for easy access
- Batch processing support (multiple message selection)
- Single message support in detail view
- Processing state management with timeout protection
- Automatic Gmail refresh after processing

### background.js
- Service worker that manages extension lifecycle
- Handles OAuth token retrieval for Gmail API access
- Establishes native messaging connection with Java backend
- Passes messages between content script and native host
- Error handling and response management

Key features:
- OAuth2 authentication flow
- Native messaging to Java application
- Batch and single message handling
- Clean error responses

### manifest.json
- Extension configuration and permissions
- OAuth2 client configuration
- Native messaging host declaration
- Content script injection rules

## Native Messaging

The extension communicates with the Java backend using Chrome's native messaging protocol:

1. **Host Manifest**: `net.sims.snarasm.json` registered with Chrome
2. **Wrapper Script**: Launches the Java application (`snarasm-native-host.sh` or `.bat`)
3. **Protocol**: JSON messages over stdin/stdout
4. **Message Format**:
   ```json
   {
     "action": "reportSpamBatch",
     "senderEmails": ["spammer@example.com"],
     "accessToken": "ya29.a0..."
   }
   ```

## Development Setup

### Prerequisites
- Google Chrome browser
- Java 17 or later
- Maven 3.6+
- OAuth2 credentials (client_secret.json)

### Building

The extension is automatically packaged during the Maven build:

```bash
# Build everything (web app, CLI, and extension)
mvn clean package

# The extension package will be created at:
# target/snarasm-ext.zip
```

### Loading the Extension (Developer Mode)

1. Build the project: `mvn clean package`
2. Extract `target/snarasm-ext.zip` to a permanent location
3. Open Chrome → `chrome://extensions/`
4. Enable "Developer mode" (toggle in top-right)
5. Click "Load unpacked"
6. Select the extracted `chrome-extension-package` folder
7. Note the Extension ID (needed for native host configuration)

### Native Host Setup

After loading the extension, you need to install the native messaging host:

**macOS/Linux:**
```bash
cd /path/to/extracted/chrome-extension-package
./install-mac.sh    # or install-linux.sh
```

**Windows:**
```powershell
cd \path\to\extracted\chrome-extension-package
.\install-windows.ps1
```

The installer will:
- Install the Java application
- Create the native messaging host manifest
- Configure Chrome to recognize the extension

## Testing

### Manual Testing
1. Load extension in Chrome (developer mode)
2. Install native messaging host
3. Open Gmail and go to Spam folder
4. Select one or more spam messages
5. Click the "Report" button that appears
6. Check console for any errors: F12 → Console tab
7. Check native host logs: 
   - macOS/Linux: `/tmp/snarasm_java.log`
   - Windows: `%TEMP%\snarasm_java.log`

### Debugging

**Extension Issues:**
- Open Chrome DevTools (F12) on Gmail page
- Check Console tab for JavaScript errors
- Inspect Network tab for API calls

**Native Messaging Issues:**
- Check that wrapper script is executable
- Verify manifest file location and content
- Check Java logs: `tail -f /tmp/snarasm_java.log`
- Test Java app directly: `java -jar snARASM-standalone-0.1-exec.jar --cli`

**Common Issues:**
- "Native host has exited" → Check Java installation and wrapper script
- "Extension ID mismatch" → Update manifest with correct extension ID
- "Authentication failed" → Check OAuth configuration in manifest.json

## OAuth Configuration

The extension uses OAuth2 for Gmail API access. The client ID is configured in `manifest.json`:

```json
"oauth2": {
  "client_id": "167900698555-rui7u4ke7gfm3ec1v1fgjnmq0aq0hbhs.apps.googleusercontent.com",
  "scopes": [
    "https://www.googleapis.com/auth/gmail.modify"
  ]
}
```

For development, you may need to:
1. Create your own Google Cloud Project
2. Enable Gmail API
3. Create OAuth2 credentials (Chrome Extension type)
4. Update the client_id in manifest.json

## File Structure

```
chrome-extension/
├── manifest.json         # Extension configuration
├── background.js         # Service worker / background script
├── content.js           # Gmail page integration
├── options.html         # Extension options page (future)
├── options.js           # Options page logic (future)
└── README.md            # This file
```

## Deployment

For production deployment, you can:

1. **Chrome Web Store** (recommended for public distribution)
   - Package the extension as a .crx file
   - Submit to Chrome Web Store
   - Users install with one click
   - Automatic updates

2. **Enterprise Deployment**
   - Use Chrome Enterprise policies
   - Deploy via group policy or MDM
   - Force-install for managed devices

3. **Developer Mode** (current method)
   - Distribute as ZIP file
   - Users load unpacked
   - Manual updates required
   - Suitable for beta testing and internal use

## Security Considerations

- OAuth tokens are managed by Chrome and never exposed to JavaScript
- Native messaging uses stdio, not network sockets
- Extension ID must match in native host manifest
- Only Gmail origin is granted content script access
- Minimal permissions requested (only gmail.modify scope)

## Performance

- Content script: ~5KB minified
- Background script: ~3KB minified
- Native messaging overhead: <10ms per message
- Batch processing: Handles up to 50 messages efficiently
- Background WHOIS lookups: Do not block UI

## Future Enhancements

- [ ] Options page for user preferences
- [ ] Whitelist/blacklist management
- [ ] Report preview before sending
- [ ] Statistics and reporting dashboard
- [ ] Support for other email providers (Outlook, Yahoo)
- [ ] Inline spam score visualization

## License

Copyright © 2014-2025 SIMS NET Inc. All rights reserved.

This software is proprietary and confidential. Unauthorized copying, distribution, or modification is prohibited.

## Support

For issues or questions:
1. Check logs: `/tmp/snarasm_java.log` (macOS/Linux) or `%TEMP%\snarasm_java.log` (Windows)
2. Verify native host installation
3. Check Chrome console for JavaScript errors
4. Test Java backend directly with CLI mode

---

**Developer Note:** This README is for developers working on the extension. For end-user installation instructions, see `docs/README.md` in the project root.