// Saves options to chrome.storage
function save_options() {
  const accountName = document.getElementById('accountName').value;
  chrome.storage.sync.set({
    snarasmAccountName: accountName
  }, () => {
    // Update status to let user know options were saved.
    const status = document.getElementById('status');
    status.textContent = 'Options saved.';
    setTimeout(() => {
      status.textContent = '';
    }, 1500);
  });
}

// Restores and auto-saves the default if no value is set
function restore_options() {
  chrome.storage.sync.get('snarasmAccountName', (items) => {
    if (!items.snarasmAccountName) {
      // No value is set. Let's set our default 'my_gmail'
      // and also save it immediately.
      const defaultAccount = 'my_gmail';
      document.getElementById('accountName').value = defaultAccount;
      chrome.storage.sync.set({
        snarasmAccountName: defaultAccount
      }, () => {
        console.log('snARASM: Default accountName "my_gmail" has been saved.');
        const status = document.getElementById('status');
        status.textContent = 'Default value saved.';
        setTimeout(() => {
          status.textContent = '';
        }, 1500);
      });
    } else {
      // A value was already set, just display it.
      document.getElementById('accountName').value = items.snarasmAccountName;
    }
  });
}

document.addEventListener('DOMContentLoaded', restore_options);
document.getElementById('save').addEventListener('click', save_options);